/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.api;

import java.lang.reflect.Method;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.IRobotUpgradeProvider;
import openperipheral.api.ITypeConverter;

public class IntegrationRegistry {
    public boolean registerAdapter(IPeripheralAdapter adapter) {
        return this.register(IPeripheralAdapter.class, adapter, "openperipheral.core.AdapterManager", "addPeripheralAdapter");
    }

    public boolean registerTypeConverter(ITypeConverter converter) {
        return this.register(ITypeConverter.class, converter, "openperipheral.core.TypeConversionRegistry", "registerTypeConverter");
    }

    public boolean registerRobotUpgradeProvider(IRobotUpgradeProvider provider) {
        return this.register(IRobotUpgradeProvider.class, provider, "openperipheral.robot.RobotUpgradeManager", "registerUpgradeProvider");
    }

    private boolean register(Class type, Object obj, String klazzName, String methodName) {
        try {
            Class<?> klazz = Class.forName(klazzName);
            if (klazz != null) {
                Method method = klazz.getMethod(methodName, type);
                method.invoke(null, obj);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

