/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import pl.asie.moducomp.CommonProxy;
import pl.asie.moducomp.CraftingHandler;
import pl.asie.moducomp.CreativeTabModuComp;
import pl.asie.moducomp.GuiHandler;
import pl.asie.moducomp.NetworkHandler;
import pl.asie.moducomp.block.BlockMainBoard;
import pl.asie.moducomp.block.BlockMusicBox;
import pl.asie.moducomp.block.BlockRAMBoard;
import pl.asie.moducomp.block.BlockTapeReader;
import pl.asie.moducomp.block.BlockTerminal;
import pl.asie.moducomp.integration.IntegrationOpenPeripheral;
import pl.asie.moducomp.integration.ModIntegration;
import pl.asie.moducomp.item.ItemCPUAreia;
import pl.asie.moducomp.item.ItemPaperTape;
import pl.asie.moducomp.item.ItemRAM;
import pl.asie.moducomp.item.ItemROM;
import pl.asie.moducomp.lib.ITileEntityOwner;

@Mod(modid="moducomp", name="Modular Computing", version="0.0.1")
@NetworkMod(channels={"ModularC"}, clientSideRequired=true, packetHandler=NetworkHandler.class)
public class ModularComputing {
    public static final boolean DEBUG = true;
    @Mod.Instance(value="moducomp")
    public static ModularComputing instance;
    public BlockTapeReader blockTapeReader;
    public BlockMusicBox blockMusicBox;
    public BlockRAMBoard blockRAMBoard;
    public BlockMainBoard blockMainBoard;
    public BlockTerminal blockTerminal;
    public ItemPaperTape itemPaperTape;
    public ItemRAM itemRAM;
    public ItemROM itemROM;
    public ItemCPUAreia itemCPUAreia;
    public CreativeTabModuComp tab;
    private Configuration config;
    @SidedProxy(clientSide="pl.asie.moducomp.ClientProxy", serverSide="pl.asie.moducomp.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;

    public static void debug(String string) {
        logger.info(string);
    }

    public Block registerBlock(Class<? extends Block> blockClass, String name, int defaultID) {
        int id = this.config.getBlock(name, defaultID).getInt();
        try {
            Block block = blockClass.getConstructor(Integer.TYPE, String.class).newInstance(id, name);
            GameRegistry.registerBlock((Block)block, (String)name);
            if (block instanceof ITileEntityOwner) {
                ITileEntityOwner teOwner = (ITileEntityOwner)block;
                GameRegistry.registerTileEntity(teOwner.getTileEntityClass(), (String)name);
            }
            return block;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Item registerItem(Class<? extends Item> itemClass, String name, int defaultID) {
        try {
            Item item = itemClass.getConstructor(Integer.TYPE, String.class).newInstance(this.config.getItem(name, defaultID).getInt(), name);
            GameRegistry.registerItem((Item)item, (String)name);
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = Logger.getLogger("moducomp");
        logger.setParent(FMLLog.getLogger());
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.tab = new CreativeTabModuComp("moducomp");
        this.blockTapeReader = (BlockTapeReader)this.registerBlock(BlockTapeReader.class, "moducomp.tape_reader", 1920);
        this.blockMusicBox = (BlockMusicBox)this.registerBlock(BlockMusicBox.class, "moducomp.music_box", 1921);
        this.blockRAMBoard = (BlockRAMBoard)this.registerBlock(BlockRAMBoard.class, "moducomp.ram_board", 1922);
        this.blockMainBoard = (BlockMainBoard)this.registerBlock(BlockMainBoard.class, "moducomp.main_board", 1923);
        this.blockTerminal = (BlockTerminal)this.registerBlock(BlockTerminal.class, "moducomp.terminal", 1924);
        this.itemPaperTape = (ItemPaperTape)this.registerItem(ItemPaperTape.class, "moducomp.paper_tape", 19200);
        this.itemRAM = (ItemRAM)this.registerItem(ItemRAM.class, "moducomp.ram", 19201);
        this.itemROM = (ItemROM)this.registerItem(ItemROM.class, "moducomp.rom", 19203);
        this.itemCPUAreia = (ItemCPUAreia)this.registerItem(ItemCPUAreia.class, "moducomp.cpu_areia", 19202);
        this.itemROM.registerROM("bios.rom", "Monitor");
        this.config.save();
        proxy.setupEvents();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.addNames();
        ModIntegration integration = new ModIntegration();
        integration.addModIntegrator(new IntegrationOpenPeripheral());
        integration.init();
        GameRegistry.registerCraftingHandler((ICraftingHandler)new CraftingHandler());
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this.itemPaperTape), (Object[])new Object[]{" x ", "x x", " x ", Character.valueOf('x'), Item.field_77759_aK});
        for (int i = 0; i < 512; ++i) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this.itemPaperTape, 1, i + 1), (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), Item.field_77759_aK, Character.valueOf('y'), new ItemStack((Item)this.itemPaperTape, 1, i)});
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }
}

