/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import pl.asie.moducomp.ModularComputing;
import pl.asie.moducomp.api.IGUIText;
import pl.asie.moducomp.block.TileEntityTapeReader;
import pl.asie.moducomp.block.TileEntityTerminal;
import pl.asie.moducomp.gui.text.TextWindow;
import pl.asie.moducomp.lib.Helper;
import pl.asie.moducomp.lib.IGUITileEntity;

public class NetworkHandler
implements IPacketHandler {
    public static void prefixTileEntity(TileEntity entity, DataOutputStream os) {
        try {
            os.writeByte(1);
            os.writeInt(entity.field_70331_k.field_73011_w.field_76574_g);
            os.writeInt(entity.field_70329_l);
            os.writeInt(entity.field_70330_m);
            os.writeInt(entity.field_70327_n);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        ModularComputing.debug("Received packet data: " + packet.field_73629_c.toString());
        DataInputStream packetData = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte commandType = packetData.readByte();
            switch (commandType) {
                case 1: {
                    World world;
                    if (!(player instanceof EntityPlayerMP)) {
                        world = ((EntityLivingBase)player).field_70170_p;
                        if (world.field_73011_w.field_76574_g != packetData.readInt()) {
                            return;
                        }
                    } else {
                        world = DimensionManager.getWorld((int)packetData.readInt());
                    }
                    int x = packetData.readInt();
                    int y = packetData.readInt();
                    int z = packetData.readInt();
                    if (world == null) {
                        return;
                    }
                    TileEntity tileEntity = world.func_72796_p(x, y, z);
                    int block = world.func_72798_a(x, y, z);
                    this.parseTEPacket(manager, packetData, player, block, tileEntity);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseTEPacket(INetworkManager manager, DataInputStream packetData, Player player, int block, TileEntity tileEntity) {
        try {
            int commandID = packetData.readUnsignedByte();
            if (!(player instanceof EntityPlayerMP)) {
                GuiScreen display = Minecraft.func_71410_x().field_71462_r;
                IGUITileEntity gui = null;
                if (display instanceof IGUITileEntity) {
                    gui = (IGUITileEntity)display;
                    TileEntity checkedTileEntity = gui.getTileEntity();
                    ModularComputing.logger.info("Received Terminal command #" + commandID + " on " + (!(player instanceof EntityPlayerMP) ? "client" : "server"));
                    if (Helper.equalTileEntities(tileEntity, checkedTileEntity) && tileEntity instanceof TileEntityTerminal && gui instanceof IGUIText) {
                        IGUIText textGui = (IGUIText)((Object)gui);
                        TextWindow window = textGui.getWindow();
                        switch (commandID) {
                            case 1: {
                                short color = packetData.readShort();
                                window.print(color, packetData.readShort());
                                break;
                            }
                            case 2: {
                                int i;
                                short width = packetData.readShort();
                                short height = packetData.readShort();
                                short x = packetData.readShort();
                                short y = packetData.readShort();
                                textGui.setHardwareEcho(packetData.readBoolean());
                                short[] chars = new short[width * height * 2];
                                for (i = 0; i < width * height * 2; ++i) {
                                    chars[i] = packetData.readShort();
                                }
                                window = new TextWindow(width, height);
                                window.x = x;
                                window.y = y;
                                window.setCharArray(chars);
                                for (i = 0; i < 64; ++i) {
                                    window.setPaletteColor(i, packetData.readShort());
                                }
                                textGui.setWindow(window);
                                break;
                            }
                            case 3: {
                                short width = packetData.readShort();
                                short height = packetData.readShort();
                                textGui.setWindow(new TextWindow(width, height));
                                break;
                            }
                            case 4: {
                                window.newline();
                                break;
                            }
                            case 5: {
                                textGui.setHardwareEcho(packetData.readBoolean());
                                break;
                            }
                            case 6: {
                                short key = packetData.readShort();
                                int excludedID = packetData.readInt();
                                if (!(player instanceof EntityPlayer)) break;
                                EntityPlayer entity = (EntityPlayer)player;
                                if (entity.field_70157_k == excludedID || window == null) break;
                                window.key(key);
                                break;
                            }
                            case 7: {
                                int number = packetData.readUnsignedByte();
                                window.setPaletteColor(number, packetData.readShort());
                            }
                        }
                    }
                }
            }
            if (tileEntity instanceof TileEntityTapeReader) {
                TileEntityTapeReader tapeReader = (TileEntityTapeReader)tileEntity;
                switch (commandID) {
                    case 1: {
                        tapeReader.setBit(packetData.readInt(), packetData.readByte(), packetData.readByte());
                        break;
                    }
                    case 2: {
                        tapeReader.setPosition(packetData.readInt());
                    }
                }
            } else if (tileEntity instanceof TileEntityTerminal) {
                TileEntityTerminal terminal = (TileEntityTerminal)tileEntity;
                if (player instanceof EntityPlayerMP) {
                    switch (commandID) {
                        case 2: {
                            terminal.onPlayerOpen(player);
                            break;
                        }
                        case 3: {
                            terminal.key(packetData.readShort(), player);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

