/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.api.computer;

import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;

public abstract class PeripheralBasic
implements IMemory {
    public static final int MAP_NONE = 0;
    public static final int MAP_BYTE = 1;
    public static final int MAP_SHORT = 2;
    public static final int MAP_SIZE = 3;
    public static final int MAP_NO_READ = 4;
    public static final int MAP_NO_WRITE = 8;
    protected final byte[] memoryMap;
    protected final short[] mapAddress;
    protected byte[] intregs = new byte[256];

    public PeripheralBasic(short author, byte id, byte deviceClass, byte[] memoryMap) {
        this.intregs[0] = (byte)(author & 0xFF);
        this.intregs[1] = (byte)(author >> 8);
        this.intregs[2] = id;
        this.intregs[3] = deviceClass;
        this.mapAddress = new short[memoryMap.length];
        this.memoryMap = new byte[256];
        for (int i = 0; i < 4; ++i) {
            this.memoryMap[i] = 9;
        }
        int j = 4;
        for (int i = 0; i < memoryMap.length; ++i) {
            if ((memoryMap[i] & 3) == 2 && (j & 1) == 1) {
                ++j;
            }
            this.mapAddress[i] = (short)j;
            this.memoryMap[j] = memoryMap[i];
            ++j;
            if ((memoryMap[i] & 3) != 2) continue;
            this.memoryMap[j] = memoryMap[i];
            ++j;
        }
        if (j < 256) {
            while (j < 256) {
                this.memoryMap[j] = 12;
                ++j;
            }
        }
    }

    public short readShort(int addr) {
        return (short)((0xFF & this.intregs[addr + 1]) << 8 | 0xFF & this.intregs[addr]);
    }

    public void writeShort(int addr, short val) {
        this.intregs[addr] = (byte)(0xFF & val);
        this.intregs[addr + 1] = (byte)(0xFF & val >> 8);
    }

    public void onReadByte(ICPU cpu, int addr) {
    }

    public void onReadShortBegin(ICPU cpu, int addr) {
    }

    public void onReadShortEnd(ICPU cpu, int addr) {
    }

    public void onWriteByte(ICPU cpu, int addr) {
    }

    public void onWriteShortBegin(ICPU cpu, int addr) {
    }

    public void onWriteShortEnd(ICPU cpu, int addr) {
    }

    @Override
    public byte read8(ICPU cpu, int addr) {
        byte mapData = this.memoryMap[addr];
        if ((mapData & 4) != 0 || (mapData & 3) == 0) {
            return -1;
        }
        if ((mapData & 3) == 1) {
            this.onReadByte(cpu, addr);
        } else if ((mapData & 3) == 2) {
            switch (addr & 1) {
                case 0: {
                    this.onReadShortBegin(cpu, addr);
                    break;
                }
                case 1: {
                    this.onReadShortEnd(cpu, addr);
                }
            }
        }
        return this.intregs[addr];
    }

    @Override
    public void write8(ICPU cpu, int addr, byte data) {
        byte mapData = this.memoryMap[addr];
        if ((mapData & 8) != 0 || (mapData & 3) == 0) {
            return;
        }
        this.intregs[addr] = data;
        if ((mapData & 3) == 1) {
            this.onWriteByte(cpu, addr);
        } else if ((mapData & 3) == 2) {
            switch (addr & 1) {
                case 0: {
                    this.onWriteShortBegin(cpu, addr);
                    break;
                }
                case 1: {
                    this.onWriteShortEnd(cpu, addr);
                }
            }
        }
    }

    @Override
    public int length() {
        return 256;
    }
}

