/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.block;

import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import pl.asie.moducomp.ModularComputing;
import pl.asie.moducomp.api.IItemCPU;
import pl.asie.moducomp.api.IMemoryControllerProvider;
import pl.asie.moducomp.api.ITileEntityPeripheral;
import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;
import pl.asie.moducomp.api.computer.IMemoryController;
import pl.asie.moducomp.block.CPUThreadMainBoard;
import pl.asie.moducomp.lib.Helper;
import pl.asie.moducomp.lib.TileEntityInventory;
import pl.asie.moducomp.peripheral.IOHandlerDebugMC;

public class TileEntityMainBoard
extends TileEntityInventory {
    private HashMap<ITileEntityPeripheral, IMemory> devices = new HashMap();
    private int ticks = 0;
    private ICPU cpu;
    private IMemoryController memory;
    private CPUThreadMainBoard currentThread;

    public TileEntityMainBoard() {
        super(1, 1, "block.moducomp.main_board");
    }

    public IMemoryController getMemoryController() {
        for (int[] dir : Helper.DIRECTIONS) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir[0], this.field_70330_m + dir[1], this.field_70327_n + dir[2]);
            if (!(te instanceof IMemoryControllerProvider)) continue;
            IMemoryControllerProvider mem = (IMemoryControllerProvider)te;
            mem.reset();
            return mem.getMemoryController();
        }
        return null;
    }

    public void getPeripherals() {
        for (int[] dir : Helper.DIRECTIONS) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir[0], this.field_70330_m + dir[1], this.field_70327_n + dir[2]);
            if (!(te instanceof ITileEntityPeripheral)) continue;
            this.devices.put((ITileEntityPeripheral)te, ((ITileEntityPeripheral)te).init(this.cpu, this.memory));
        }
    }

    public void func_70316_g() {
        if ((this.ticks & 3) == 0) {
            for (ITileEntityPeripheral peripheral : this.devices.keySet()) {
                if (!(peripheral instanceof TileEntity)) {
                    return;
                }
                TileEntity te = (TileEntity)peripheral;
                if (!te.func_70320_p()) continue;
                peripheral.deinit(this.cpu);
                IMemory memory = this.devices.get(peripheral);
                for (int i = 0; i < 16; ++i) {
                    if (this.memory.getDeviceSlot(i) != memory) continue;
                    this.memory.setDeviceSlot(i, null);
                }
            }
        }
        ++this.ticks;
    }

    private void unloadPeripherals() {
        for (ITileEntityPeripheral peripheral : this.devices.keySet()) {
            peripheral.deinit(this.cpu);
        }
    }

    private void unload() {
        this.unloadPeripherals();
    }

    public boolean isCPUInserted() {
        ItemStack cpuStack = this.func_70301_a(0);
        return cpuStack != null && cpuStack.func_77973_b() instanceof IItemCPU;
    }

    public boolean isBlockPowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) || this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
    }

    @Override
    public void onInventoryChanged(int slot) {
        if (slot == 0) {
            if (!this.isCPUInserted()) {
                this.end();
            } else if (this.isCPUInserted() && this.isBlockPowered()) {
                this.begin();
            }
        }
    }

    public boolean isRunning() {
        return this.currentThread != null;
    }

    public void begin() {
        if (!this.isCPUInserted()) {
            return;
        }
        this.end();
        this.memory = this.getMemoryController();
        if (this.memory == null) {
            return;
        }
        ItemStack cpuStack = this.func_70301_a(0);
        IItemCPU itemCPU = (IItemCPU)cpuStack.func_77973_b();
        this.cpu = itemCPU.createNewCPUHandler(cpuStack);
        if (this.cpu == null) {
            return;
        }
        this.memory.setDeviceSlot(15, new IOHandlerDebugMC(this));
        this.getPeripherals();
        int i = 0;
        for (ITileEntityPeripheral peripheral : this.devices.keySet()) {
            ModularComputing.logger.info("Adding peripheral: " + peripheral.toString() + ", slot " + i);
            if (peripheral.getPreferredDeviceID() >= 0 && peripheral.getPreferredDeviceID() <= 15) {
                int id = peripheral.getPreferredDeviceID();
                if (this.memory.getDeviceSlot(id) != null) continue;
                this.memory.setDeviceSlot(id, this.devices.get(peripheral));
                continue;
            }
            while (this.memory.getDeviceSlot(i) != null) {
                ++i;
            }
            if (i >= 15) break;
            this.memory.setDeviceSlot(i, this.devices.get(peripheral));
            if (++i < 15) continue;
            break;
        }
        this.cpu.setMemoryHandler(this.memory);
        this.cpu.resetCold();
        ModularComputing.debug("Starting emulation!");
        this.currentThread = new CPUThreadMainBoard(this.cpu, 250000);
        new Thread(this.currentThread).start();
    }

    public void end() {
        if (this.isRunning()) {
            this.currentThread.kill();
            this.currentThread = null;
            this.unload();
        }
    }
}

