/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.block;

import cpw.mods.fml.common.network.Player;
import net.minecraft.entity.player.EntityPlayer;
import pl.asie.moducomp.api.ITileEntityPeripheral;
import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;
import pl.asie.moducomp.api.computer.IMemoryController;
import pl.asie.moducomp.gui.text.TextWindow;
import pl.asie.moducomp.lib.PacketSender;
import pl.asie.moducomp.lib.TileEntityInventory;
import pl.asie.moducomp.peripheral.IOHandlerTerminal;

public class TileEntityTerminal
extends TileEntityInventory
implements ITileEntityPeripheral {
    public TextWindow window;
    private IOHandlerTerminal terminal = new IOHandlerTerminal(this);
    private ICPU cpu;
    private boolean hardwareEcho;

    public TileEntityTerminal() {
        super(1, 1, "block.moducomp.terminal");
    }

    public void print(short color, short chr) {
        this.print(color, chr, false);
    }

    public void print(short color, short chr, boolean send) {
        this.window.print(color, chr);
        if (send) {
            PacketSender sender = new PacketSender(this, 1);
            try {
                sender.stream.writeShort(color);
                sender.stream.writeShort(chr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sender.sendAround(this);
        }
    }

    public void setPalette(int number, short col) {
        this.window.setPaletteColor(number, col);
        PacketSender sender = new PacketSender(this, 7);
        try {
            sender.stream.writeByte((byte)number);
            sender.stream.writeShort(col);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sender.sendAround(this);
    }

    public void keyExcludingPlayer(short chr, int excludedID) {
        PacketSender sender = new PacketSender(this, 6);
        try {
            sender.stream.writeShort(chr);
            sender.stream.writeInt(excludedID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sender.sendAround(this);
    }

    public void newline(boolean send) {
        this.window.newline();
        if (send) {
            PacketSender sender = new PacketSender(this, 4);
            sender.sendAround(this);
        }
    }

    public void key(short key, Player sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)sender;
        }
        if (this.cpu == null || this.terminal == null) {
            return;
        }
        if (this.terminal.addKey(this.cpu, key)) {
            this.window.key(key);
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                this.keyExcludingPlayer(key, player.field_70157_k);
            }
        }
    }

    public void setHardwareEcho(boolean is) {
        this.hardwareEcho = is;
        PacketSender sender = new PacketSender(this, 5);
        try {
            sender.stream.writeBoolean(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sender.sendAround(this);
    }

    public void onPlayerOpen(Player player) {
        if (this.window == null) {
            this.clear(false);
        }
        PacketSender sender = new PacketSender(this, 2);
        try {
            sender.stream.writeShort(this.window.width);
            sender.stream.writeShort(this.window.height);
            sender.stream.writeShort(this.window.x);
            sender.stream.writeShort(this.window.y);
            sender.stream.writeBoolean(this.hardwareEcho);
            short[] chars = this.window.getCharArray();
            for (int i = 0; i < this.window.width * this.window.height * 2; ++i) {
                sender.stream.writeShort(chars[i]);
            }
            short[] colors = this.window.getPalette();
            for (int i = 0; i < 64; ++i) {
                sender.stream.writeShort(colors[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sender.sendToPlayer(player);
    }

    @Override
    public IMemory init(ICPU cpu, IMemoryController memoryController) {
        this.cpu = cpu;
        this.clear(true);
        return this.terminal;
    }

    private void clear(boolean send) {
        this.window = new TextWindow(30, 22);
        if (send) {
            PacketSender sender = new PacketSender(this, 3);
            try {
                sender.stream.writeShort(this.window.width);
                sender.stream.writeShort(this.window.height);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sender.sendAround(this);
        }
    }

    @Override
    public void deinit(ICPU cpu) {
        this.cpu = null;
        this.terminal = null;
        this.clear(true);
    }

    @Override
    public int getPreferredDeviceID() {
        return -1;
    }
}

