/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.computer.cpu;

import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;

public class CPUAreia
implements ICPU {
    public int cycles;
    public static final int F_ZERO = 1;
    public static final int F_CARRY = 2;
    public static final int F_OVERFLOW = 4;
    public static final int F_SIGNED = 8;
    public static final int F_INTERRUPT = 16;
    public static final int UOP_NOP = 0;
    public static final int UOP_RET = 1;
    public static final int UOP_POPF = 2;
    public static final int UOP_PUSHF = 3;
    public static final int UOP_CLI = 4;
    public static final int UOP_SEI = 5;
    public static final int UOP_HLT = 6;
    public static final int UOP_GSEG = 8;
    public static final int UOP_SSEG = 9;
    public static final int UOP_MOVE = 16;
    public static final int UOP_ADD = 17;
    public static final int UOP_CMP = 18;
    public static final int UOP_SUB = 19;
    public static final int UOP_XOR = 20;
    public static final int UOP_OR = 21;
    public static final int UOP_AND = 22;
    public static final int UOP_ROL = 24;
    public static final int UOP_ROR = 25;
    public static final int UOP_RCL = 26;
    public static final int UOP_RCR = 27;
    public static final int UOP_ASR = 28;
    public static final int UOP_ASL = 29;
    public static final int UOP_LSR = 30;
    public static final int UOP_LD = 32;
    public static final int UOP_ST = 40;
    public static final int UOP_JZ = 48;
    public static final int UOP_JNZ = 49;
    public static final int UOP_JC = 50;
    public static final int UOP_JNC = 51;
    public static final int UOP_JV = 52;
    public static final int UOP_JNV = 53;
    public static final int UOP_JS = 54;
    public static final int UOP_JNS = 55;
    public static final int UOP_JMP = 56;
    public static final int UOP_JSR = 57;
    private IMemory memctl;
    private int pc;
    private short flags;
    private boolean halted;
    private boolean open_hatch;
    private short[] regs = new short[16];
    private byte[] segs = new byte[4];
    private byte[] intregs = new byte[128];
    private SavedUopBank[] uop_cache = new SavedUopBank[8];
    private int uop_cache_ptr;
    private int waitCycles;
    private int interruptVector;

    public CPUAreia() {
        for (int i = 0; i < this.uop_cache.length; ++i) {
            this.uop_cache[i] = new SavedUopBank();
            this.uop_cache[i].chain = new SavedUop[64];
            this.uop_cache[i].pc_start = -1;
        }
        this.uop_cache_ptr = 0;
        this.interruptVector = -1;
        this.halted = false;
    }

    @Override
    public int getAddressBitLength() {
        return 20;
    }

    @Override
    public IMemory getMemoryHandler() {
        return this.memctl;
    }

    @Override
    public void setMemoryHandler(IMemory ctl) {
        this.memctl = ctl;
    }

    private byte read8(int addr) {
        byte val = -1;
        val = this.open_hatch || addr <= 1048447 ? (byte)this.memctl.read8(this, addr) : this.intregs[(addr &= 0xFFFFF) & 0x7F];
        ++this.cycles;
        return val;
    }

    private short read16(int addr) {
        int v0 = 0xFF & this.read8(addr);
        int v1 = 0xFF & this.read8(addr + 1 & 0xFFFFF);
        return (short)(v0 | v1 << 8);
    }

    private void write8(int addr, byte val) {
        if ((addr &= 0xFFFFF) <= 1048447) {
            this.memctl.write8(this, addr, val);
        } else if ((addr &= 0x7F) >= 4 && addr < 8) {
            int n = addr;
            this.intregs[n] = (byte)(this.intregs[n] & val);
        } else {
            this.intregs[addr] = val;
        }
        ++this.cycles;
    }

    private void write16(int addr, short val) {
        int vi = 0xFFFF & val;
        this.write8(addr, (byte)(vi & 0xFF));
        this.write8(addr + 1 & 0xFFFFF, (byte)(vi >> 8 & 0xFF));
    }

    public byte fetch8() {
        byte val = this.read8(this.pc);
        ++this.pc;
        return val;
    }

    public short fetch16() {
        short val = this.read16(this.pc);
        this.pc += 2;
        return val;
    }

    @Override
    public void resetWarm() {
        int i;
        this.flags = 0;
        for (i = 0; i < 16; ++i) {
            this.regs[i] = 0;
        }
        for (i = 0; i < 4; ++i) {
            this.segs[i] = 0;
        }
        int pc_low = 0xFFFF & this.read16(1048572);
        int pc_high = 0xFF & this.read8(1048574);
        this.pc = (pc_low | pc_high << 16) & 0xFFFFF;
    }

    @Override
    public void resetCold() {
        int i;
        for (i = 0; i < 128; ++i) {
            this.intregs[i] = 0;
        }
        this.flags = 0;
        this.open_hatch = true;
        for (i = 0; i < 3; ++i) {
            this.write8(1048572 + i, this.read8(1048572 + i));
        }
        this.open_hatch = false;
        this.resetWarm();
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void debugPC(int pc) {
        int i;
        System.out.printf("%05X:", pc);
        System.out.printf(" %04X", 0xFFFF & this.flags);
        for (i = 0; i < 4; ++i) {
            System.out.printf(" %02X", 0xFF & this.segs[i]);
        }
        for (i = 1; i < 16; ++i) {
            System.out.printf(" %04X", 0xFFFF & this.regs[i]);
        }
        System.out.println();
    }

    public void debugPC() {
        this.debugPC(this.pc);
    }

    public void clearUops() {
        for (int i = 0; i < this.uop_cache.length; ++i) {
            this.uop_cache[i].pc_start = -1;
        }
    }

    private int loadUop() {
        int op = 0xFF & this.fetch8();
        int rop = -1;
        int rmode = 0;
        int rx = 0;
        int ry = 0;
        int rimm = 0;
        int rsize = 0;
        block0 : switch (op >> 6 & 3) {
            case 0: {
                rsize = 1;
                if (op < 7) {
                    rop = op & 0x3F;
                    break;
                }
                if (op < 16 || op > 17) break;
                rop = (op & 7) + 8;
                int rpair = 0xFF & this.fetch8();
                rx = rpair >> 4;
                ry = rpair & 0xF;
                assert (ry <= 3);
                break;
            }
            case 1: {
                if ((op & 7) == 7) break;
                rsize = 1 + (op >> 4 & 1);
                rmode = op >> 5 & 1;
                rop = (op & 0xF) + 16;
                int rpair = 0xFF & this.fetch8();
                rx = rpair >> 4;
                ry = rpair & 0xF;
                if (rmode == 0) break;
                if (rsize == 2) {
                    rimm = 0xFFFF & this.fetch16();
                    break;
                }
                rimm = 0xFF & this.fetch8();
                break;
            }
            case 2: {
                rsize = 1 + (op >> 2 & 1);
                rmode = (op >> 4 & 3) == 1 ? 1 : 0;
                rop = (op & 0xB) + 32;
                int rpair = 0xFF & this.fetch8();
                rx = rpair >> 4;
                ry = rpair & 0xF;
                switch (op >> 4 & 3) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        rimm = 0xFFFF & this.fetch16();
                        break;
                    }
                    case 2: {
                        rimm = 0xFFFF & this.fetch8();
                    }
                }
                break;
            }
            case 3: {
                int rpair;
                rsize = 1 + (op >> 4 & 1);
                if ((op & 0xF) < 10) {
                    rop = (op & 0xF) + 48;
                }
                rmode = op >> 5 & 1;
                switch (op >> 4 & 3) {
                    case 0: {
                        rpair = 0xFF & this.fetch8();
                        rx = rpair >> 4;
                        ry = rpair & 0xF;
                    }
                    case 1: {
                        rimm = 0xFFFF & this.fetch16();
                        break block0;
                    }
                    case 2: {
                        rimm = 0xFFFF & this.fetch8();
                        break block0;
                    }
                    case 3: {
                        rimm = 0xFFFF & this.fetch16();
                    }
                }
            }
        }
        if (rop == -1) {
            throw new RuntimeException(String.format("unsupported op %02X at position %05X", op, this.pc));
        }
        int ret = 0;
        ret |= rsize == 2 ? Integer.MIN_VALUE : 0;
        ret |= (rmode & 1) << 30;
        ret |= (rop & 0x7F) << 24;
        ret |= (ry & 0xF) << 16;
        ret |= (rx & 0xF) << 20;
        return ret |= rimm & 0xFFFF;
    }

    private void setFlag(int flag, boolean check) {
        this.flags = check ? (short)(this.flags | flag) : (short)(this.flags & ~flag);
    }

    private void setParityFlag(short val) {
        byte v = (byte)(val ^ val >> 8);
        this.setFlag(4, (27030 >> ((v ^ v >> 4) & 0xF) & 1) != 0);
    }

    private short doUopStep(int size, int mode, int op, int rx, int ry, int imm, short fmask) throws HaltCPU {
        if ((op & 0x30) == 48) {
            imm = mode == 1 ? this.pc + (short)imm : (size == 1 ? (ry << 16) + imm + (0xFFFF & this.regs[rx]) : this.pc & 0xF0000 | imm);
            imm &= 0xFFFFF;
        }
        switch (op) {
            case 0: {
                break;
            }
            case 16: {
                return (short)(mode == 0 ? this.regs[ry] : imm);
            }
            case 18: 
            case 19: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx - vy;
                if ((fmask & 2) != 0) {
                    this.setFlag(2, vx < vy);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 4) != 0) {
                    if (((vx ^ vy) & (size == 2 ? 32768 : 128)) == 0) {
                        int axval;
                        int aimm = vy < 32768 ? vy : 65536 - vy;
                        int n = axval = vx < 32768 ? vx : 65536 - vx;
                        if (size == 2) {
                            if ((fmask & 4) != 0) {
                                this.setFlag(4, aimm + axval >= 32768);
                            } else if ((fmask & 4) != 0) {
                                this.setFlag(4, aimm + axval >= 128);
                            }
                        }
                    } else if ((fmask & 4) != 0) {
                        this.setFlag(4, false);
                    }
                }
                if (op == 18) break;
                return (short)ret;
            }
            case 17: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx + vy;
                if ((fmask & 2) != 0) {
                    this.setFlag(2, size == 2 ? ret >= 65536 : ret >= 256);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 4) != 0) {
                    if (((vx ^ vy) & (size == 2 ? 32768 : 128)) == 0) {
                        int axval;
                        int aimm = vy < 32768 ? vy : 65536 - vy;
                        int n = axval = vx < 32768 ? vx : 65536 - vx;
                        if (size == 2) {
                            if ((fmask & 4) != 0) {
                                this.setFlag(4, aimm + axval >= 32768);
                            } else if ((fmask & 4) != 0) {
                                this.setFlag(4, aimm + axval >= 128);
                            }
                        }
                    } else if ((fmask & 4) != 0) {
                        this.setFlag(4, false);
                    }
                }
                if (op == 18) break;
                return (short)ret;
            }
            case 20: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx ^ vy;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                return (short)ret;
            }
            case 21: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx | vy;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                return (short)ret;
            }
            case 22: {
                int vy;
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int n = vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                if (size == 1) {
                    vy |= 0xFF00;
                }
                int ret = vx & vy;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                return (short)ret;
            }
            case 29: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx << vy;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 2) != 0) {
                    this.setFlag(2, (ret & 0x10000) != 0);
                }
                return (short)ret;
            }
            case 28: {
                int retpre;
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx >> vy;
                int n = retpre = vy == 0 ? vx << 1 : vx >> vy - 1;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 2) != 0) {
                    this.setFlag(2, (retpre & 1) != 0);
                }
                return (short)ret;
            }
            case 30: {
                int retpre;
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int ret = vx >>> vy;
                int n = retpre = vy == 0 ? vx << 1 : vx >>> vy - 1;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 2) != 0) {
                    this.setFlag(2, (retpre & 1) != 0);
                }
                return (short)ret;
            }
            case 24: {
                int ret;
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int n = ret = size == 2 ? (vx << (vy & 0xF) | vx >>> 16 - (vy & 0xF)) & 0xFFFF : (vx << (vy & 7) | vx >>> 8 - (vy & 7)) & 0xFF;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                return (short)ret;
            }
            case 25: {
                int ret;
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = mode != 0 ? imm : 0xFFFF & this.regs[ry];
                int n = ret = size == 2 ? (vx >>> (vy & 0xF) | vx << 16 - (vy & 0xF)) & 0xFFFF : (vx >>> (vy & 7) | vx << 8 - (vy & 7)) & 0xFF;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                return (short)ret;
            }
            case 26: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = (mode != 0 ? imm : 0xFFFF & this.regs[ry]) % (size == 2 ? 17 : 9);
                int ret = size == 2 ? vx | ((this.flags & 2) > 0 ? 65536 : 0) : vx | ((this.flags & 2) > 0 ? 256 : 0);
                int n = ret = size == 2 ? ret << vy | ret >>> 17 - vy : ret << vy | ret >>> 9 - vy;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 2) != 0) {
                    this.setFlag(2, (ret & (size == 2 ? 65536 : 256)) != 0);
                }
                return (short)ret;
            }
            case 27: {
                int vx = 0xFFFF & this.regs[mode == 0 ? rx : ry];
                int vy = (mode != 0 ? imm : 0xFFFF & this.regs[ry]) % (size == 2 ? 17 : 9);
                int ret = size == 2 ? vx | ((this.flags & 2) > 0 ? 65536 : 0) : vx | ((this.flags & 2) > 0 ? 256 : 0);
                int n = ret = size == 2 ? ret >>> vy | ret << 17 - vy : ret >>> vy | ret << 9 - vy;
                if ((fmask & 4) != 0) {
                    this.setParityFlag((short)(ret & (size == 2 ? 65535 : 255)));
                }
                if ((fmask & 8) != 0) {
                    this.setFlag(8, (ret & (size == 2 ? 32768 : 128)) != 0);
                }
                if ((fmask & 1) != 0) {
                    this.setFlag(1, (ret & (size == 2 ? 65535 : 255)) == 0);
                }
                if ((fmask & 2) != 0) {
                    this.setFlag(2, (ret & (size == 2 ? 65536 : 256)) != 0);
                }
                return (short)ret;
            }
            case 48: {
                if ((this.flags & 1) == 0) break;
                this.pc = imm;
                break;
            }
            case 49: {
                if ((this.flags & 1) != 0) break;
                this.pc = imm;
                break;
            }
            case 50: {
                if ((this.flags & 2) == 0) break;
                this.pc = imm;
                break;
            }
            case 51: {
                if ((this.flags & 2) != 0) break;
                this.pc = imm;
                break;
            }
            case 54: {
                if ((this.flags & 8) == 0) break;
                this.pc = imm;
                break;
            }
            case 55: {
                if ((this.flags & 8) != 0) break;
                this.pc = imm;
                break;
            }
            case 52: {
                if ((this.flags & 4) == 0) break;
                this.pc = imm;
                break;
            }
            case 53: {
                if ((this.flags & 4) != 0) break;
                this.pc = imm;
                break;
            }
            case 56: {
                this.pc = imm;
                break;
            }
            case 57: {
                this.regs[15] = (short)(this.regs[15] - 1);
                this.write8(0xF0000 | 0xFFFF & this.regs[15], (byte)(this.pc >> 16));
                this.regs[15] = (short)(this.regs[15] - 2);
                this.write16(0xF0000 | 0xFFFF & this.regs[15], (short)this.pc);
                this.pc = imm;
                break;
            }
            case 3: {
                this.regs[15] = (short)(this.regs[15] - 2);
                this.write16(0xF0000 | 0xFFFF & this.regs[15], this.flags);
                break;
            }
            case 2: {
                this.flags = (short)(0xFFFF & this.read16(0xF0000 | 0xFFFF & this.regs[15]));
                this.regs[15] = (short)(this.regs[15] + 2);
                break;
            }
            case 1: {
                int pc_low = 0xFFFF & this.read16(0xF0000 | 0xFFFF & this.regs[15]);
                this.regs[15] = (short)(this.regs[15] + 2);
                int pc_high = 0xF & this.read8(0xF0000 | 0xFFFF & this.regs[15]);
                this.regs[15] = (short)(this.regs[15] + 1);
                this.pc = pc_low + (pc_high << 16);
                break;
            }
            case 4: {
                this.setFlag(16, false);
                break;
            }
            case 5: {
                this.setFlag(16, true);
                break;
            }
            case 6: {
                this.halted = true;
                throw new HaltCPU();
            }
            case 8: {
                return this.segs[ry & 3];
            }
            case 9: {
                this.segs[ry & 3] = (byte)this.regs[rx];
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                int seg = op & 3;
                int offs = (mode == 0 ? ((0xFF & this.segs[seg]) << 12) + (0xFFFF & this.regs[ry]) : (seg == 3 ? 0 : (0xFF & this.segs[seg]) << 12) + (ry << 16)) + imm & 0xFFFFF;
                if (size == 2) {
                    return this.read16(offs);
                }
                return this.read8(offs);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                int seg = op & 3;
                int offs = (mode == 0 ? ((0xFF & this.segs[seg]) << 12) + (0xFFFF & this.regs[ry]) : (seg == 3 ? 0 : (0xFF & this.segs[seg]) << 12) + (ry << 16)) + imm & 0xFFFFF;
                if (size == 2) {
                    this.write16(offs, this.regs[rx]);
                    break;
                }
                this.write8(offs, (byte)this.regs[rx]);
                break;
            }
            default: {
                throw new RuntimeException(String.format("unsupported uop: %d %d %d %d %04X", op, size, rx, ry, imm));
            }
        }
        return this.regs[rx];
    }

    private void doUop(int uop_data, short fmask, boolean use_ret) throws HaltCPU {
        int size = (uop_data >> 31 & 1) + 1;
        int mode = uop_data >> 30 & 1;
        int op = uop_data >> 24 & 0x3F;
        int rx = uop_data >> 20 & 0xF;
        int ry = uop_data >> 16 & 0xF;
        int imm = uop_data & 0xFFFF;
        short ret = this.doUopStep(size, mode, op, rx, ry, imm, fmask);
        if (use_ret) {
            this.regs[rx] = size == 2 ? ret : (short)(this.regs[rx] & 0xFF00 | 0xFF & ret);
        }
    }

    private short opFlagWrites(int op) {
        if (op >= 18 && op <= 19) {
            return 15;
        }
        if (op >= 20 && op <= 22) {
            return 13;
        }
        if (op >= 29 && op <= 27) {
            return 15;
        }
        if (op == 2) {
            return -1;
        }
        return 0;
    }

    private boolean opCanJump(int op) {
        return op >= 48 && op <= 57 || op == 1 || op == 6;
    }

    private boolean opReturns(int op, int rx) {
        if (rx == 0) {
            return false;
        }
        switch (op >> 4 & 3) {
            case 0: {
                return op == 8;
            }
            case 1: {
                return op != 18;
            }
            case 2: {
                return op < 40;
            }
        }
        return false;
    }

    private SavedUopBank fetchUopChain() {
        SavedUopBank bank = null;
        int lpc = this.pc;
        int lcyc = this.cycles;
        for (int i = 0; i < this.uop_cache.length; ++i) {
            bank = this.uop_cache[i];
            if (bank.pc_start != lpc) continue;
            return bank;
        }
        bank = this.uop_cache[this.uop_cache_ptr];
        this.uop_cache_ptr = this.uop_cache_ptr + 1 & this.uop_cache.length - 1;
        SavedUop[] chain = bank.chain;
        bank.pc_start = lpc;
        for (int i = 0; i < chain.length; ++i) {
            SavedUop sop;
            chain[i] = sop = this.fetchUop();
            if (sop.can_jump) break;
        }
        bank.pc_end = this.pc;
        bank.load_cycles = this.cycles - lcyc;
        this.pc = lpc;
        this.cycles = lcyc;
        this.tweakUopChain(lpc, bank.chain);
        return bank;
    }

    private void tweakUopChain(int base_pc, SavedUop[] ul) {
        int[] pc_fw = new int[]{-1, -1, -1, -1};
        int pc = base_pc;
        for (int i = 0; i < ul.length; ++i) {
            short fm;
            SavedUop sop = ul[i];
            if (sop.can_jump) break;
            int op = sop.uop >> 24 & 0x7F;
            if (op == 26 || op == 27) {
                pc_fw[1] = -1;
            }
            if (((fm = this.opFlagWrites(op)) & 1) != 0) {
                if (pc_fw[0] != -1) {
                    ul[pc_fw[0]].fmask = (short)(ul[pc_fw[0]].fmask & 0xFFFFFFFE);
                }
                pc_fw[0] = i;
            }
            if ((fm & 2) != 1) {
                if (pc_fw[1] != -1) {
                    ul[pc_fw[1]].fmask = (short)(ul[pc_fw[1]].fmask & 0xFFFFFFFD);
                }
                pc_fw[1] = i;
            }
            if ((fm & 4) != 2) {
                if (pc_fw[2] != -1) {
                    ul[pc_fw[2]].fmask = (short)(ul[pc_fw[2]].fmask & 0xFFFFFFFB);
                }
                pc_fw[2] = i;
            }
            if ((fm & 8) != 3) {
                if (pc_fw[3] != -1) {
                    ul[pc_fw[3]].fmask = (short)(ul[pc_fw[3]].fmask & 0xFFFFFFF7);
                }
                pc_fw[3] = i;
            }
            pc = sop.new_pc;
        }
    }

    private SavedUop fetchUop() {
        int lpc = this.pc;
        int ocyc = this.cycles;
        int uop_data = this.loadUop();
        int ncyc = this.cycles;
        int op = uop_data >> 24 & 0x3F;
        int rx = uop_data >> 20 & 0xF;
        SavedUop sop = new SavedUop(uop_data, ncyc - ocyc, this.pc, -1, this.opReturns(op, rx), this.opCanJump(op));
        return sop;
    }

    @Override
    public void wait(int cycles) {
        this.waitCycles += cycles;
    }

    @Override
    public boolean interrupt(int line) {
        if (this.cycles < 2) {
            return false;
        }
        if ((this.flags & 0x10) == 0) {
            return false;
        }
        int addr = 4 + (line >> 3);
        int pos = 1 << (line & 7);
        int n = addr;
        this.intregs[n] = (byte)(this.intregs[n] | (byte)pos);
        int vector = 0xFF & this.intregs[0];
        vector |= (0xFF & this.intregs[1]) << 8;
        this.interruptVector = vector |= (0xF & this.intregs[2]) << 16;
        return true;
    }

    @Override
    public int run(int count) {
        int cyc_end = count + this.cycles;
        try {
            block2: while (cyc_end - this.cycles > 0) {
                if (this.interruptVector >= 0) {
                    this.regs[15] = (short)(this.regs[15] - 1);
                    this.write8(0xF0000 | 0xFFFF & this.regs[15], (byte)(this.pc >> 16));
                    this.regs[15] = (short)(this.regs[15] - 2);
                    this.write16(0xF0000 | 0xFFFF & this.regs[15], (short)this.pc);
                    this.regs[15] = (short)(this.regs[15] - 2);
                    this.write16(0xF0000 | 0xFFFF & this.regs[15], this.flags);
                    this.pc = this.interruptVector;
                    this.interruptVector = -1;
                }
                if (this.waitCycles > 0) {
                    if (cyc_end - this.cycles <= this.waitCycles) {
                        this.cycles += this.waitCycles;
                        this.waitCycles = 0;
                        continue;
                    }
                    int diff = cyc_end - this.cycles;
                    this.cycles = cyc_end;
                    this.waitCycles -= diff;
                    continue;
                }
                int lpc = this.pc;
                SavedUopBank bank = this.fetchUopChain();
                SavedUop[] uop_chain = bank.chain;
                this.pc = bank.pc_end;
                for (int i = 0; i < uop_chain.length; ++i) {
                    SavedUop sop = uop_chain[i];
                    this.cycles += sop.load_cycles;
                    this.doUop(sop.uop, sop.fmask, sop.use_ret);
                    if (sop.can_jump) continue block2;
                }
            }
        }
        catch (HaltCPU haltCPU) {
            // empty catch block
        }
        return cyc_end - this.cycles;
    }

    private class SavedUopBank {
        public int pc_start;
        public int pc_end;
        public int load_cycles;
        public SavedUop[] chain;

        private SavedUopBank() {
        }
    }

    private class SavedUop {
        public int uop;
        public byte load_cycles;
        public short fmask;
        public int new_pc;
        public boolean use_ret;
        public boolean can_jump;

        public SavedUop(int uop, int load_cycles, int new_pc, short fmask, boolean use_ret, boolean can_jump) {
            this.uop = uop;
            this.load_cycles = (byte)load_cycles;
            this.new_pc = new_pc;
            this.fmask = fmask;
            this.use_ret = use_ret;
            this.can_jump = can_jump;
        }
    }

    private class HaltCPU
    extends Exception {
        private HaltCPU() {
        }
    }
}

