/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.computer.memory;

import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;
import pl.asie.moducomp.api.computer.IMemoryController;

public class MemoryControllerSlot
implements IMemoryController {
    protected IMemory[] memorySlots = new IMemory[16];
    protected IMemory[] slots = new IMemory[16];
    protected IMemory[] deviceSlots = new IMemory[16];

    @Override
    public void setSlot(int idx, IMemory slot) {
        if (idx < 0 && idx > 15) {
            return;
        }
        this.slots[idx] = slot;
        if (idx == 0) {
            this.memorySlots[0] = slot;
            this.memorySlots[15] = slot;
        } else if (idx <= 14) {
            this.memorySlots[idx] = slot;
        }
    }

    public void setROM(IMemory slot) {
        this.setSlot(15, slot);
    }

    @Override
    public void setDeviceSlot(int idx, IMemory slot) {
        if (idx < 0 && idx > 15) {
            return;
        }
        this.deviceSlots[idx] = slot;
    }

    @Override
    public IMemory getDeviceSlot(int idx) {
        if (idx < 0 && idx > 15) {
            return null;
        }
        return this.deviceSlots[idx];
    }

    public int setAddress(ICPU cpu, int addr) {
        addr &= 0xFFFFF;
        switch (cpu.getAddressBitLength()) {
            default: {
                return 0;
            }
            case 20: {
                return addr;
            }
            case 16: 
        }
        return addr & 0xFFFF | 0xF0000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte read8(ICPU cpu, int addr) {
        if ((addr = this.setAddress(cpu, addr)) < 1032192) {
            IMemory slot = this.memorySlots[addr >> 16 & 0xF];
            if (slot == null) {
                return -1;
            }
            IMemory iMemory = slot;
            synchronized (iMemory) {
                return slot.read8(cpu, addr & 0xFFFF);
            }
        }
        if (addr <= 1036287) {
            return -1;
        }
        if (addr <= 1040383) {
            IMemory slot = this.deviceSlots[addr >> 8 & 0xF];
            if (slot != null) {
                IMemory iMemory = slot;
                synchronized (iMemory) {
                    return slot.read8(cpu, addr & 0xFF);
                }
            }
            return -1;
        }
        IMemory slot = this.slots[15];
        if (slot != null) {
            IMemory iMemory = slot;
            synchronized (iMemory) {
                return slot.read8(cpu, addr & 0x1FFF);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write8(ICPU cpu, int addr, byte val) {
        if ((addr = this.setAddress(cpu, addr)) < 1032192) {
            IMemory slot = this.memorySlots[addr >> 16 & 0xF];
            if (slot != null) {
                IMemory iMemory = slot;
                synchronized (iMemory) {
                    slot.write8(cpu, addr & 0xFFFF, val);
                }
            }
        } else if (addr > 1036287) {
            if (addr <= 1040383) {
                IMemory slot = this.deviceSlots[addr >> 8 & 0xF];
                if (slot != null) {
                    IMemory iMemory = slot;
                    synchronized (iMemory) {
                        slot.write8(cpu, addr & 0xFF, val);
                    }
                }
            } else {
                IMemory slot = this.slots[15];
                if (slot != null) {
                    IMemory iMemory = slot;
                    synchronized (iMemory) {
                        slot.write8(cpu, addr & 0x1FFF, val);
                    }
                }
            }
        }
    }

    @Override
    public int length() {
        return -1;
    }
}

