/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.computer.memory;

import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;

public class MemoryHandlerRAM
implements IMemory {
    private byte[] data;
    private final int size;

    public MemoryHandlerRAM(int size) {
        this.size = size;
        this.data = new byte[size];
    }

    @Override
    public byte read8(ICPU cpu, int addr) {
        if (addr < 0 || addr >= this.size) {
            return 0;
        }
        return this.data[addr];
    }

    @Override
    public void write8(ICPU cpu, int addr, byte val) {
        if (addr < 0 || addr >= this.size) {
            return;
        }
        this.data[addr] = val;
    }

    @Override
    public int length() {
        return this.size;
    }
}

