/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pl.asie.moducomp.api.IItemTape;
import pl.asie.moducomp.block.TileEntityTapeReader;
import pl.asie.moducomp.gui.ContainerTapeReader;
import pl.asie.moducomp.item.ItemPaperTape;
import pl.asie.moducomp.lib.PacketSender;

@SideOnly(value=Side.CLIENT)
public class GuiTapeReader
extends GuiContainer {
    private static final ResourceLocation tapeTexture = new ResourceLocation("moducomp", "textures/gui/tape_reader.png");
    private ContainerTapeReader tapeReaderInventory;
    private TileEntityTapeReader tapeReaderEntity;
    private static final int TAPE_HOLES_Y = 172;
    private static final int TAPE_OUTLINES_Y = 185;
    private static final int TAPE_Y = 38;
    private static final int TAPE_YOFF = 14;
    private static final int[][] TAPE_INFO = new int[][]{{62, 0}, {74, 12}, {86, 24}, {109, 47}, {121, 59}, {133, 71}, {145, 83}, {157, 95}, {98, 36}};

    public GuiTapeReader(InventoryPlayer inventoryPlayer, TileEntityTapeReader tileEntity) {
        super((Container)new ContainerTapeReader(inventoryPlayer, tileEntity));
        this.tapeReaderEntity = tileEntity;
        this.field_74194_b = 176;
        this.field_74195_c = 166;
    }

    protected void func_74189_g(int par1, int par2) {
    }

    protected void drawTape(ItemStack tape, IItemTape tapeHandler, int offset, int xo, int yo) {
        if (tapeHandler.isValid(tape, offset)) {
            int value = tapeHandler.getByte(tape, offset) & 0xFF;
            for (int i = 0; i <= 8; ++i) {
                if (i == 8 || (value & 1 << 7 - i) > 0) {
                    this.func_73729_b(xo + TAPE_INFO[i][0], yo + 38 + offset * 14, TAPE_INFO[i][1], 172, 9, 9);
                    continue;
                }
                this.func_73729_b(xo + TAPE_INFO[i][0], yo + 38 + offset * 14, TAPE_INFO[i][1], 185, 9, 9);
            }
        }
    }

    protected void func_73869_a(char keyChar, int key) {
        super.func_73869_a(keyChar, key);
        ItemStack tape = this.tapeReaderEntity.func_70301_a(0);
        if (tape != null && tape.func_77973_b() instanceof ItemPaperTape) {
            ItemPaperTape tapeHandler = (ItemPaperTape)tape.func_77973_b();
            boolean changed = true;
            if (key == 200) {
                tapeHandler.seek(tape, -1);
            } else if (key == 208) {
                tapeHandler.seek(tape, 1);
            } else {
                changed = false;
            }
            if (changed) {
                this.sendPositionPacket();
            }
        }
    }

    private void sendPositionPacket() {
        PacketSender sender = new PacketSender();
        sender.prefixTileEntity(this.tapeReaderEntity);
        try {
            sender.stream.writeByte(2);
            sender.stream.writeInt(this.tapeReaderEntity.getPosition());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sender.sendServer();
    }

    private void sendBitSetPacket(byte offset, byte shift) {
        PacketSender sender = new PacketSender();
        sender.prefixTileEntity(this.tapeReaderEntity);
        try {
            sender.stream.writeByte(1);
            sender.stream.writeInt(this.tapeReaderEntity.getPosition());
            sender.stream.writeByte(offset);
            sender.stream.writeByte(shift);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sender.sendServer();
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            int xo = (this.field_73880_f - this.field_74194_b) / 2;
            int yo = (this.field_73881_g - this.field_74195_c) / 2;
            int bit = -1;
            for (int i = 0; i <= 7; ++i) {
                int xpos = xo + TAPE_INFO[i][0];
                if (x < xpos || x >= xpos + 9) continue;
                bit = 7 - i;
                break;
            }
            if (bit >= 0) {
                int offset = -3;
                for (int i = -2; i <= 2; ++i) {
                    int ypos = yo + 38 + i * 14;
                    if (y < ypos || y >= ypos + 9) continue;
                    offset = i;
                    break;
                }
                if (offset >= -3) {
                    this.sendBitSetPacket((byte)offset, (byte)bit);
                }
            }
        }
    }

    public void func_73874_b() {
        this.sendPositionPacket();
    }

    protected void func_74185_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(tapeTexture);
        int xo = (this.field_73880_f - this.field_74194_b) / 2;
        int yo = (this.field_73881_g - this.field_74195_c) / 2;
        ItemStack tape = this.tapeReaderEntity.func_70301_a(0);
        if (tape != null && tape.func_77973_b() instanceof ItemPaperTape) {
            ItemPaperTape tapeHandler = (ItemPaperTape)tape.func_77973_b();
            this.func_73729_b(xo + 60, yo + 14, 0, 199, 108, 57);
            for (int i = -2; i <= 2; ++i) {
                this.drawTape(tape, tapeHandler, i, xo, yo);
            }
        } else {
            this.func_73729_b(xo + 60, yo + 14, 108, 199, 108, 57);
        }
        this.func_73729_b(xo, yo, 0, 0, this.field_74194_b, this.field_74195_c);
    }
}

