/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.gui.text;

import pl.asie.moducomp.ModularComputing;

public class TextWindow {
    public static final int TAB_SIZE = 4;
    public final int width;
    public final int height;
    private short[] display;
    private short[] palette;
    public int x;
    public int y;
    private short lastColor = (short)15;

    public TextWindow(int width, int height) {
        this.width = width;
        this.height = height;
        this.display = new short[width * height * 2];
        this.palette = new short[256];
        this.palette[0] = 0;
        for (int i = 1; i < 256; ++i) {
            this.palette[i] = Short.MAX_VALUE;
        }
        this.x = 0;
        this.y = 0;
    }

    private void scrollUp() {
        System.arraycopy(this.display, this.width, this.display, 0, this.width * (this.height - 1));
        System.arraycopy(this.display, this.width * (this.height + 1), this.display, this.width * this.height, this.width * (this.height - 1));
        for (int i = this.width * (this.height - 1); i < this.width * this.height; ++i) {
            this.display[i] = 0;
            this.display[this.width * this.height + i] = 0;
        }
        --this.y;
    }

    public void newline() {
        this.x = 0;
        ++this.y;
        if (this.y == this.height) {
            this.scrollUp();
        }
    }

    private void advance() {
        ++this.x;
        if (this.x == this.width) {
            this.newline();
        }
    }

    public void key(int key) {
        if (key == 13) {
            this.newline();
        } else if (key == 8 || key == 127) {
            if (this.x > 0) {
                --this.x;
            } else if (this.y > 0) {
                this.x = this.width - 1;
                --this.y;
            } else {
                return;
            }
            this.display[this.x + this.y * this.width] = 0;
        } else if (key == 9) {
            for (int i = 0; i < 4; ++i) {
                this.print(this.lastColor, (short)32);
            }
        } else if (key >= 32 && key < 127) {
            this.print(this.lastColor, (short)key);
        }
    }

    public void print(short color, short chr) {
        this.lastColor = color;
        ModularComputing.logger.info("Printing character " + chr + "(x is " + this.x + ", y is " + this.y + ", color is " + this.lastColor + ", x0y0 is " + this.display[0] + ")");
        this.display[this.x + this.y * this.width] = chr;
        this.display[this.x + (this.y + this.height) * this.width] = color;
        this.advance();
    }

    public void print(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.print((short)Short.MAX_VALUE, (short)string.charAt(i));
        }
    }

    public short[] getPalette() {
        return this.palette;
    }

    public void setPaletteColor(int number, short color) {
        this.palette[number & 0x3F] = color;
    }

    public short getColor(byte color) {
        return this.palette[color & 0x3F];
    }

    public short[] getCharArray() {
        return this.display;
    }

    public void setCharArray(short[] arr) {
        this.display = arr;
    }
}

