/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.moducomp.ModularComputing;
import pl.asie.moducomp.api.IItemTape;

public class ItemPaperTape
extends Item
implements IItemTape {
    public static final int MAX_TAPE_LENGTH = 512;

    public ItemPaperTape(int id, String name) {
        super(id);
        this.func_77655_b(name);
        this.func_111206_d("moducomp:paper_tape");
        this.func_77637_a(ModularComputing.instance.tab);
    }

    private boolean check(ItemStack stack) {
        if (stack.field_77993_c != this.field_77779_bT) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("TapePosition", 0);
            compound.func_74773_a("TapeData", new byte[this.getLength(stack)]);
            stack.func_77982_d(compound);
        } else {
            NBTTagCompound compound = stack.func_77978_p();
            if (!compound.func_74764_b("TapePosition") || !compound.func_74764_b("TapeData")) {
                compound.func_74768_a("TapePosition", 0);
                compound.func_74773_a("TapeData", new byte[this.getLength(stack)]);
            }
            if (compound.func_74770_j("TapeData").length != this.getLength(stack)) {
                compound.func_74773_a("TapeData", new byte[this.getLength(stack)]);
            }
            stack.func_77982_d(compound);
        }
        return true;
    }

    @Override
    public int getSeekLength(ItemStack stack, int bytes) {
        if (this.check(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            int currentPosition = compound.func_74762_e("TapePosition");
            int targetPosition = currentPosition + bytes;
            if (targetPosition < 0) {
                targetPosition = 0;
            } else if (targetPosition >= this.getLength(stack)) {
                targetPosition = this.getLength(stack) - 1;
            }
            return targetPosition - currentPosition;
        }
        return 0;
    }

    @Override
    public void seek(ItemStack stack, int bytes) {
        if (this.check(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            int currentPosition = compound.func_74762_e("TapePosition");
            int targetPosition = currentPosition + this.getSeekLength(stack, bytes);
            compound.func_74768_a("TapePosition", targetPosition);
            stack.func_77982_d(compound);
        }
    }

    public int getPosition(ItemStack stack) {
        if (this.check(stack)) {
            return stack.func_77978_p().func_74762_e("TapePosition");
        }
        return 0;
    }

    public void setPosition(ItemStack stack, int pos) {
        if (this.check(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            compound.func_74768_a("TapePosition", pos);
            stack.func_77982_d(compound);
        }
    }

    public ItemStack extend(ItemStack stack, ItemStack oldStack, boolean copyData) {
        if (this.check(stack) && this.check(oldStack) && oldStack.func_77960_j() < 512) {
            stack.func_77964_b(oldStack.func_77960_j() + 1);
            if (copyData) {
                NBTTagCompound compound = stack.func_77978_p();
                byte[] newData = new byte[this.getLength(stack)];
                byte[] oldData = oldStack.func_77978_p().func_74770_j("TapeData");
                System.arraycopy(oldData, 0, newData, 0, oldData.length);
                compound.func_74773_a("TapeData", newData);
                stack.func_77982_d(compound);
            }
            return stack;
        }
        return null;
    }

    @Override
    public void setByte(ItemStack stack, byte val, int offset) {
        if (this.check(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            byte[] data = compound.func_74770_j("TapeData");
            int pos = compound.func_74762_e("TapePosition") + offset;
            if (pos < 0 || pos >= this.getLength(stack)) {
                return;
            }
            data[pos] = val;
            compound.func_74773_a("TapeData", data);
            stack.func_77982_d(compound);
        }
    }

    @Override
    public byte getByte(ItemStack stack, int offset) {
        if (this.check(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            int pos = compound.func_74762_e("TapePosition") + offset;
            if (pos < 0 || pos >= this.getLength(stack)) {
                return 0;
            }
            return compound.func_74770_j("TapeData")[pos];
        }
        return 0;
    }

    @Override
    public boolean isValid(ItemStack stack, int offset) {
        if (this.check(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            int target = compound.func_74762_e("TapePosition") + offset;
            int length = this.getLength(stack);
            return target >= 0 && target < length;
        }
        return false;
    }

    @Override
    public int getLength(ItemStack stack) {
        if (stack.field_77993_c != this.field_77779_bT) {
            return 0;
        }
        return (1 + (0xFFFF & stack.func_77960_j())) * 32;
    }

    public NBTTagCompound reset(NBTTagCompound compound) {
        compound.func_74768_a("TapePosition", 0);
        return compound;
    }

    @Override
    public void reset(ItemStack stack) {
        if (this.check(stack)) {
            stack.func_77982_d(this.reset(stack.func_77978_p()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(this.getLength(stack) + " bytes");
    }
}

