/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.lib;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityInventory
extends TileEntity
implements IInventory {
    protected ItemStack[] inventory;
    protected int maxStackSize;
    protected String inventoryName;

    public TileEntityInventory(int size, int mss, String name) {
        this.inventory = new ItemStack[size];
        this.maxStackSize = size;
        if (this.maxStackSize < 1) {
            this.maxStackSize = 1;
        }
        if (this.maxStackSize > 64) {
            this.maxStackSize = 64;
        }
        this.inventoryName = name;
    }

    public TileEntityInventory(int size, int mss) {
        this(size, mss, "modular.inventory");
    }

    public TileEntityInventory(int size, String name) {
        this(size, 64, name);
    }

    public TileEntityInventory(int size) {
        this(size, 64);
    }

    public void func_70296_d() {
    }

    public void onInventoryChanged(int slot) {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public String func_70303_b() {
        return this.inventoryName;
    }

    public int func_70297_j_() {
        return this.maxStackSize;
    }

    public boolean func_94042_c() {
        boolean hasUpper = !this.inventoryName.equals(this.inventoryName.toLowerCase());
        boolean hasDots = this.inventoryName.indexOf(".") >= 0;
        return hasUpper || !hasDots;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack == null) {
            return null;
        }
        this.inventory[slot] = null;
        return stack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                this.func_70296_d();
                this.onInventoryChanged(slot);
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.func_70296_d();
            this.onInventoryChanged(slot);
            return itemstack;
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i < 0 || i >= this.inventory.length) {
            return false;
        }
        return stack == null || stack.field_77994_a <= this.maxStackSize;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.onInventoryChanged(slot);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        NBTTagList tagList = tagCompound.func_74761_m("Inventory");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
    }
}

