/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.peripheral;

import net.minecraft.item.ItemStack;
import pl.asie.moducomp.api.IItemTape;
import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;
import pl.asie.moducomp.api.computer.PeripheralBasic;
import pl.asie.moducomp.block.TileEntityTapeReader;

public class IOHandlerTapeReader
extends PeripheralBasic
implements IMemory,
Runnable {
    private static final int SPEED = 10;
    private static final byte[] memoryMapFinal = new byte[]{1, 1, 2, 1, 9};
    private boolean[] flags;
    private TileEntityTapeReader tapeReader;
    private int seekBytes = 0;
    private ICPU seekCPU;

    public IOHandlerTapeReader(TileEntityTapeReader tileEntity) {
        super((short)-23266, (byte)2, (byte)2, memoryMapFinal);
        this.tapeReader = tileEntity;
        this.intregs[5] = 1;
        this.flags = new boolean[8];
    }

    private void setReadByte() {
        IItemTape handler = this.tapeReader.getHandler();
        if (handler == null) {
            this.intregs[8] = -1;
        } else {
            ItemStack tape = this.tapeReader.getTape();
            this.intregs[8] = handler.getByte(tape, 0);
        }
    }

    @Override
    public void onReadByte(ICPU cpu, int addr) {
        switch (addr) {
            case 4: {
                int value = 0;
                for (int i = 0; i < 8; ++i) {
                    value |= (this.flags[i] ? 1 : 0) << i;
                }
                this.intregs[addr] = (byte)value;
                break;
            }
            case 8: {
                this.setReadByte();
            }
        }
    }

    @Override
    public void onWriteByte(ICPU cpu, int addr) {
        switch (addr) {
            case 4: {
                int value = 0xFF & this.intregs[addr];
                for (int i = 0; i < 8; ++i) {
                    this.flags[i] = (value & 1 << i) > 0;
                }
                break;
            }
            case 8: {
                ItemStack tape = this.tapeReader.getTape();
                IItemTape handler = this.tapeReader.getHandler();
                if (handler == null) {
                    return;
                }
                byte current = handler.getByte(tape, 0);
                handler.setByte(tape, (byte)(current | this.intregs[addr]), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWriteShortEnd(ICPU cpu, int addr) {
        switch (addr) {
            case 7: {
                this.seekCPU = cpu;
                this.seekBytes = this.readShort(6);
                IOHandlerTapeReader iOHandlerTapeReader = this;
                synchronized (iOHandlerTapeReader) {
                    this.intregs[9] = 1;
                    this.writeShort(6, (short)0);
                    new Thread(this).start();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ItemStack tape = this.tapeReader.getTape();
        IItemTape handler = this.tapeReader.getHandler();
        if (handler == null) {
            return;
        }
        int bytes = Math.abs(handler.getSeekLength(tape, this.seekBytes));
        long time = bytes * 10;
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int interruptLane = this.intregs[5] & 0x1F;
        IOHandlerTapeReader iOHandlerTapeReader = this;
        synchronized (iOHandlerTapeReader) {
            tape = this.tapeReader.getTape();
            if (tape != null) {
                handler.seek(tape, this.seekBytes);
                this.setReadByte();
                this.writeShort(6, (short)bytes);
            } else {
                this.writeShort(6, (short)0);
            }
            this.intregs[9] = 0;
        }
        if (interruptLane >= 0 && interruptLane < 28) {
            this.seekCPU.interrupt(interruptLane);
        }
    }
}

