/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.moducomp.peripheral;

import pl.asie.moducomp.api.computer.ICPU;
import pl.asie.moducomp.api.computer.IMemory;
import pl.asie.moducomp.api.computer.PeripheralBasic;
import pl.asie.moducomp.block.TileEntityTerminal;

public class IOHandlerTerminal
extends PeripheralBasic
implements IMemory {
    public static final int FLAG_HARDWARE_ECHO = 0;
    public static final int FLAG_INTERRUPT = 1;
    public static final int FLAG_OUTPUT_SIZE = 2;
    private TileEntityTerminal board;
    private static final byte[] memoryMapFinal = new byte[]{1, 0, 1, 0, 2, 2, 10, 5, 0, 2, 1};
    protected boolean[] flags;
    protected short[] lastKeys;
    protected short lastKeyPos = 0;

    public IOHandlerTerminal(TileEntityTerminal tileEntityTerminal) {
        super((short)-23266, (byte)1, (byte)1, memoryMapFinal);
        this.board = tileEntityTerminal;
        this.flags = new boolean[8];
        this.lastKeys = new short[24];
        this.intregs[10] = 15;
        this.intregs[11] = 0;
    }

    @Override
    public void onReadByte(ICPU cpu, int addr) {
        switch (addr) {
            case 4: {
                int value = 0;
                for (int i = 0; i < 8; ++i) {
                    value |= (this.flags[i] ? 1 : 0) << i;
                }
                this.intregs[addr] = (byte)value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onReadShortBegin(ICPU cpu, int addr) {
        switch (addr) {
            case 12: {
                short[] sArray = this.lastKeys;
                synchronized (this.lastKeys) {
                    short key = this.lastKeys[0];
                    this.intregs[12] = (byte)(key & 0xFF);
                    this.intregs[13] = (byte)(key >> 8 & 0xFF);
                    if (this.lastKeyPos > 0) {
                        System.arraycopy(this.lastKeys, 1, this.lastKeys, 0, this.lastKeys.length - 1);
                        this.lastKeyPos = (short)(this.lastKeyPos - 1);
                    }
                    this.lastKeys[this.lastKeyPos] = 0;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    @Override
    public void onWriteByte(ICPU cpu, int addr) {
        switch (addr) {
            case 4: {
                int value = 0xFF & this.intregs[addr];
                for (int i = 0; i < 8; ++i) {
                    this.flags[i] = (value & 1 << i) > 0;
                }
                this.board.setHardwareEcho(this.flags[0]);
                break;
            }
            case 14: {
                this.board.newline(true);
            }
        }
    }

    @Override
    public void onWriteShortBegin(ICPU cpu, int addr) {
        if (!this.flags[2]) {
            return;
        }
        switch (addr) {
            case 8: {
                this.board.print(this.getColor(), (short)((short)this.intregs[addr] & 0xFF), true);
            }
        }
    }

    public short getColor() {
        return (short)((0xFF & this.intregs[11]) << 8 | 0xFF & this.intregs[10]);
    }

    @Override
    public void onWriteShortEnd(ICPU cpu, int addr) {
        switch (addr) {
            case 9: {
                this.board.print(this.getColor(), this.readShort(8), true);
                break;
            }
            case 17: {
                this.board.setPalette(0xFF & this.intregs[18], this.readShort(16));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKey(ICPU cpu, short key) {
        int interruptLane = 0xFF & this.intregs[6];
        short[] sArray = this.lastKeys;
        synchronized (this.lastKeys) {
            System.arraycopy(this.lastKeys, 0, this.lastKeys, 1, this.lastKeys.length - 1);
            this.lastKeys[0] = key;
            this.lastKeyPos = (short)(this.lastKeyPos + 1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.flags[1] && interruptLane >= 0 && interruptLane < 28) {
                cpu.interrupt(interruptLane);
            }
            return this.flags[0];
        }
    }
}

